<?php
/* $KimmoSuominen: .www/htdocs/sw/finquote/finquote.php,v 1.6 2011-10-02 14:19:18 kim Exp $
 *
 * Copyright (c) 2005-2007 Kimmo Suominen
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer
 *    in the documentation and/or other materials provided with the
 *    distribution.
 * 3. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior
 *    written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
 * IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
 * IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
Plugin Name: Norske sitatteikn
Plugin URI: http://hamskifte.com/filer/norquote.zip
Description: Rått kopiert frå Kimmo Suominen sin Finquote (http://kimmo.suominen.com/sw/finquote/) og endra til norske sitatteikn.
Author: Kimmo Suominen, tilpassa norsk av Monica Lie
Version: 2.2
Author URI: http://kimmo.suominen.com/
*/

class FinQuote
{
    function FinQuote()
    {
	// Add to filters from wp-includes/default-filters.php
	add_filter('bloginfo',
	    array(&$this, 'fintexturize'), 12);
	add_filter('category_description',
	    array(&$this, 'fintexturize'), 12);
	add_filter('comment_author',
	    array(&$this, 'fintexturize'), 12);
	add_filter('comment_text',
	    array(&$this, 'fintexturize'), 12);
	add_filter('list_cats',
	    array(&$this, 'fintexturize'), 12);
	add_filter('the_content',
	    array(&$this, 'fintexturize'), 12);
	add_filter('the_excerpt',
	    array(&$this, 'fintexturize'), 12);
	add_filter('the_title',
	    array(&$this, 'fintexturize'), 12);

	// It might be a cool idea to go through all filters
	// and always add after finding wptexturize.
    }

    function fintexturize($text) {
	$output = '';

	// Capture tags and everything inside them
	$tarr = preg_split("/(<.*>)/Us", $text, -1, PREG_SPLIT_DELIM_CAPTURE);

	// loop stuff
	$stop = count($tarr); $next = true;
	for ($i = 0; $i < $stop; $i++) {
	    $curl = $tarr[$i];
	    if (isset($curl{0}) && '<' != $curl{0} && $next) {
		// If it's not a tag
		$curl = str_replace('&#8220;', '&#171;', $curl);
		$curl = str_replace('&#8221;', '&#187;', $curl);
	    } elseif (strstr($curl, '<code') || strstr($curl, '<pre')
		|| strstr($curl, '<kbd' || strstr($curl, '<style')
		|| strstr($curl, '<script'))) {
		// strstr is fast
		$next = false;
	    } else {
		$next = true;
	    }
	    $output .= $curl;
	}

	return $output;
    }
}

$wppFinQuote = new FinQuote;

?>
